#include <iostream>
#include <algorithm>
#include <string>
#include <vector>
#include <queue>
#include <stack>
#include <map>
#include <math.h>
#include <utility>
#define ll long long
#define vint vector<int>
#define vll vector<ll>
#define vb vector<bool>
#define pb push_back

using namespace std;

vector<int> adj;
vb platforms;
void addConnection(int upper, int lower) {
	adj[lower] = upper;  
}

vint dp;
int dynamic(vint& prefix, int i, int index, int n) {
	if (index == n - 1)
		return 0;
	int count = 0;
	if (dp[index] == INT_MAX) {
		for (int j = n - 1; j > index; j--) {
			if (prefix[j] - prefix[index] <= i) {
				int a = dynamic(prefix, i, j, n);
				if (a + 1 < dp[index])
					dp[index] = a + 1;
			}
		}
	}
	return dp[index];
}
int distance(int src, int dst) {
	int dist = 0;
	int u = src;
	while (u != dst) {
		u = adj[u];
		dist++;
	}
	return dist;
}
int traversal(int k) {
	if (k == 1)
		return 1;
	vector<int> possible;
	int u = k;
	possible.pb(u);
	while (adj[u] != 0) {
		if (platforms[adj[u]])
			possible.pb(adj[u]);
		u = adj[u];
	}
	possible.pb(0);
	vint paths(possible.size() - 1);
	for (int i = 0; i < possible.size() - 1; i++)
		paths[i] = distance(possible[i], possible[i + 1]);

	possible.resize(0);
	vint prefix(paths.size() + 1);
	prefix[0] = 0;
	for (int i = 1; i <= paths.size(); i++)
		prefix[i] = paths[i - 1] + prefix[i - 1];

	dp.resize(prefix.size() + 1, INT_MAX);
	int ret = dynamic(prefix, k, 0, prefix.size());
	if (ret == INT_MAX)
		ret = -1;
	dp.resize(0);
	return ret;
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	int n; cin >> n;
	adj.resize(n + 1);
	for (int i = 0; i < n - 1; i++) {
		int upper, lower;
		cin >> upper >> lower;
		addConnection(upper, lower);
	}
	int roomstate;
	platforms.resize(n + 1);
	platforms[0] = 1;
	for (int i = 1; i <= n; i++) {
		int roomstate;
		cin >> roomstate;
		if (roomstate == 1)
			platforms[i] = true;
	}
	vint jumps(n + 1);
	for (int i = 1; i <= n; i++) {
		cin >> roomstate;
		if (roomstate != 0) {
			platforms[roomstate] = !platforms[roomstate];
		}
		jumps[i] = traversal(i);
	}

	for (int i = 1; i <= n; i++)
		cout << jumps[i] << " ";
	cout << "\n";
}